#!/usr/bin/perl -w

# ClonePanel - Manages duplicate accounts on two or more webservers,
# including snapshot backups, monitoring and failover dns.
# Copyright (C)2006 Chris Cheers, Internet Lynx.
# Contact chris[at]clonepanel[dot]com.
# Internet Lynx, PO Box 7117, Mannering Park, NSW 2259, Australia

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

# Version=0.33
# dns_utils.pl - perl script provides utility subroutines for reading a zone
# file, optionally modifying ip addresses and serial no
# Should be included only by *dns.pl scripts


sub readzonefile {
	my ($domain,$filename,$over_keywords,$acips,$ttl) = @_;
	$over_keywords = [] unless $over_keywords;
	$acips = {} unless $acips;
	$ttl='' unless $ttl;
	open INFILE, $filename or return (0);
	my $zonetext;
	{									#localise this block for slurp
		local $/;
		$zonetext = <INFILE>;
	} 
	close INFILE;
	if (@$over_keywords) {
# Modify zone information with data given, if any (see mod_dns.pl)
		$zonetext =~ s/DOMAIN/$domain/g;
		$zonetext =~ s/TTL/$ttl/g;
		foreach my $keyword (@$over_keywords) {		#loop through WEB_MASTER etc.	
			if (!exists $acips->{$keyword} || !$acips->{$keyword}) {
				warn "$domain: no IP address for $keyword (check roles file)";
				$zonetext =~ s/$keyword/127.0.0.1/g;
				next
			}
			my $ip = $acips->{$keyword};			#current IP address
			$zonetext =~ s/$keyword/$ip/g;
		}
	}

	my $rzone = Net::DNS::ZoneFile::Fast::parse($zonetext) or die "Failed to create zone";
	return $rzone;						#return a listref of RR records
}
	


sub modzone {										#modify the given zone with new serial and overridden records
	my ($domain,$rzone,$overfile,$over_keywords,$acips,$ttl)=@_;
	my $overrides = readzonefile($domain,$overfile,$over_keywords,$acips,$ttl);
		# fetch a listref if zone records to override existing ones
	my (undef,undef,undef,$mday,$mon,$year)=gmtime(time);
	my $datestamp=sprintf("%04d%02d%02d",$year+1900,$mon+1,$mday);
	my $index=1;
	my @newzone;
	my $soa = shift @$rzone;
	die "Error - first record type not SOA" unless $soa->type eq 'SOA';
	my $serial = $soa->serial;

	if ($serial =~ /^$datestamp(\d+)$/) {			#current serial number today
		$index=$1;
		$index++;
	}
	my $newsoa = Net::DNS::RR->new(
			name => $soa->name,
			ttl => $soa->ttl,
			class => "IN",
			type => "SOA",
			mname => $soa->mname,
			rname => $soa->rname,
			serial => $datestamp . sprintf("%02d",$index),
			refresh => $soa->refresh,
			retry => $soa->retry,
			expire => $soa->expire,
			minimum => $soa->minimum,
			);
	push @newzone,($newsoa,@$overrides);			#modified SOA and overridden records copied to new zone
	
EXR: foreach my $exrr (@$rzone) {				#now loop through existing RR records
		my ($exname,$extype) = ($exrr->name, $exrr->type);
		foreach my $orr (@$overrides) {
			my ($oname,$otype) = ($orr->name, $orr->type);
			next EXR if $exname eq $oname && $extype eq $otype;
		}
		push @newzone,$exrr;					#add existing record if NOT overridden
	}
	return \@newzone;
}

sub readfileashash {
	my $filename=shift;
	open INFILE, $filename or die "Can't open $filename for read";
	my %data;
	while (my $line = <INFILE>) {
		chomp $line;
		next unless $line;
		$line=~/\s*([^\=]+)\=[\s'"]*(.*?)[\s'"]*$/;
		$data{$1}=$2 if ($1);			
	}
	return \%data;
}

sub cleandomainnames {
	my @clean;
	while (@_) {
		if (my $domain = shift @_) {
			$domain =~ s/\.\.//g;
			$domain =~ s/[^\w\.\-]//g;
			push @clean,$domain;
		}
	}
	return @clean
}

1

