#!/usr/bin/perl -w

# ClonePanel - Manages duplicate accounts on two or more webservers,
# including snapshot backups, monitoring and failover dns.
# Copyright (C)2006 Chris Cheers, Internet Lynx.
# Contact chris[at]clonepanel[dot]com.
# Internet Lynx, PO Box 7117, Mannering Park, NSW 2259, Australia

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

# Version=0.33
# get_dns.pl - perl script to read a series of zones from a master DNS server,
# check the serial number and update the local copy if newer
# Should be called only by get_dns shell script

use strict;
use Net::DNS;
use Net::DNS::ZoneFile::Fast;
require "dns_utils.pl";

my ($dir, $zonefn, $ip, @domains) = @ARGV;
$zonefn =~ s/[^\w\.\-]//g if $zonefn;
$dir =~ s/[^\w\.\-\/]//g if $dir;
$ip =~ s/[^\d\.]//g if $ip;
die "Usage:  ./get_dns.pl dir filename ip zone1 [zone2 zone3 ...]" unless @domains;

foreach my $domain (@domains) {
	$domain =~ s/#.*//;
	next unless $domain =~ /\w/;
	my $zonefile = "$dir/$domain/$zonefn";

	my $res  = Net::DNS::Resolver->new;
	$res->nameservers($ip);			#set nameserver to given

	my @zone = $res->axfr($domain) or die "Failed to get zone transfer from $ip";
	my $soa = $zone[0];
	die "Error - first record type not SOA" unless $soa->type eq 'SOA';
	my $newserial = $soa->serial;

# This is the serial number of the zone as read from the dns master

	my $rzone = readzonefile($domain,$zonefile);
	my $oldserial;
	if (ref $rzone) {
		$soa = $$rzone[0];
		die "Error - first record type not SOA" unless $soa->type eq 'SOA';
		$oldserial = $soa->serial;
	} else {
		print "Warning: Failed to open zone file for read\n";
		$oldserial = 'Not found';
	}
# This is the serial number of the local zone file

	if ( $newserial eq $oldserial ) {
		print "Local zone file is up to date\n";
		next;
	}
	print "New serial number is $newserial, old is $oldserial - updating zone file";

	open OUT, ">$zonefile" or die "Unable to open zone file for write";
	foreach my $rr (@zone) {
		print OUT $rr->string, "\n";
	}
	close OUT;
}

