#!/usr/bin/perl -w

# ClonePanel - Manages duplicate accounts on two or more webservers,
# including snapshot backups, monitoring and failover dns.
# Copyright (C)2006 Chris Cheers, Internet Lynx.
# Contact chris[at]clonepanel[dot]com.
# Internet Lynx, PO Box 7117, Mannering Park, NSW 2259, Australia

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

# Version=0.33
# mod_dns.pl - perl script reads a zone file and modifies ip addresses and serial no
# Should be called only by failover shell script

use strict;
use Net::DNS;
use Net::DNS::ZoneFile::Fast;
require "dns_utils.pl";

my $over_keywords = [qw/WEB_MASTER WEB_SLAVE MAIL_MASTER MAIL_SLAVE SEND_MASTER/];
# keywords to be replaced in dns overrides file (from acstatus). NB - also DOMAIN and TTL

my ($zonefile, $overfile, $rolesfile, $hostsdir, $hostsfilename, $zone) = @ARGV;
$zonefile =~ s/[^\w\.\-\/]//g if $zonefile;
$overfile =~ s/[^\w\.\-\/]//g if $overfile;
$rolesfile =~ s/[^\w\.\-\/]//g if $rolesfile;
$hostsdir =~ s/[^\w\.\-\/]//g if $hostsdir;
$hostsfilename =~ s/[^\w\.\-]//g if $hostsfilename;
my ($domain) = cleandomainnames($zone);

die "Usage:  ./mod_dns.pl zonefile overfile rolesfile hostsdir hostconfigfilename zone" unless $domain;

my $ttl=300;					#legacy only - now included in override file
my $roles = readfileashash($rolesfile);			#hashref of account info
my $hosts = {};						#hashref of host configs

my $acips={};												#IP addresses of A records for each host
foreach my $role (keys %$roles) {
	my $svr = $roles->{$role};
	next if exists $hosts->{$svr};
	$hosts->{$svr} = readfileashash("$hostsdir/$svr/$hostsfilename");
# First time through, just define all config for all hosts with a role
}
foreach my $role (keys %$roles) {
# Second time, get IP addresses and adjust for down servers
	my $svr = $roles->{$role};
	my $ip = $hosts->{$svr}->{A} or die "No IP for $role ($svr)";
	$acips->{$role} = $ip;
}

$domain =~ s/#.*//;
exit(0) unless $domain =~ /\w/;

print "Fetching zone $domain from $zonefile... ";
my $rzone = readzonefile($domain,$zonefile)
	or die "Failed to read zone $domain from local file";
print "Done\nModifying zone records... ";
$rzone = modzone($domain,$rzone,$overfile,$over_keywords,$acips,$ttl)
	or die "Failed to modify zone";
print "Done\nWriting modified zone file...";
open OUT, ">$zonefile" or die "Unable to open zone file for write";
foreach my $rr (@$rzone) {
	print OUT $rr->string, "\n";
}
close OUT;
print "Done\n";

