#!/bin/sh

# up.cgi - display uptime, load average and other data for monitoring

exec 2>&1
# Display errors

query="$QUERY_STRING"
# Store query string - possible call to check other host

set -u
# Be strict about variable declaration

unset PATH
#avoid use of $PATH - limit script to system commands we choose

# Set or change the following paths to point to the remote clonepanel directory:
SYNC_DIR='/home/[USERNAME]/cp0.30'

# Setup database access (also needs manual setup of 'mytest' table in database)
DB_NUM=1
# Corresponds to include file in databases directory (default first db defined)
DB_TEST="update mytest set t=now()"
# Statement to test database access

. $SYNC_DIR/rconfig
# Load remote host config

LWP_REQUEST=/usr/bin/lwp-request
# Perl tool similar to wget

$ECHO "Content-Type: text/plain"
$ECHO

if [ "$query" ]; then
# Request for check on another host
	. $SYNC_DIR/mconfig
# Additional config for monitors
	checkhost=`$ECHO $query | $SED -n 's/^CHECK=\([A-Za-z0-9_]*\).*/\1/p'`
# Permit only single parameter CHECK and only alphanumerics in value
	if [ ! "$checkhost" ]; then
		exit 2
	fi

	HOSTS_FILE=$REMOTEHOST_HOSTS_DIR/$checkhost/$HOSTS_CONFIG_FILENAME
# Configuration info for this host
	if [ ! -f "$HOSTS_FILE" ]; then
		exit 2
	fi
	. $HOSTS_FILE
	$ECHO "proxy=Checking $checkhost"

	$LWP_REQUEST -t $MONITOR_TIMEOUT -H Host:$MONITOR_HOST -H "User-Agent:$MONITOR_USER_AGENT" http://$MONITOR_IP/$MONITOR_PATH
# Recheck named host from here and return the results

else

	$ECHO -n "uptime=";/usr/bin/uptime
	$ECHO -n "df=";/bin/df /home |$TAIL -n1
	$ECHO -n "free=";/usr/bin/free -mo |$TAIL -n2
                        
	if [ -f "$REMOTEHOST_DATABASE_DIR/$DB_NUM" ]; then
		. $REMOTEHOST_DATABASE_DIR/$DB_NUM
# Include database access data
	fi
	if [ "$DB_HOST_OVERRIDE" ] ;	then op_host="-h$DB_HOST_OVERRIDE"
	elif [ "$db_host" ];		then op_host="-h$db_host"
	else op_host=""
	fi
	if [ "$db_table" ];	then db_file="${db_name}-$db_table.sql"
	else db_file="${db_name}.sql"
	fi
	if [ "$db_name" ] ;	then
		err=`$MYSQL -u$db_user -e "$DB_TEST" -p$db_password $op_host $db_name 2>&1`
	else err="Failed to define database access params"
	fi

	if [ "$err" ]; then
		$ECHO "mysql=$err"
	else
		$ECHO "mysql=ok"
	fi
	
fi


