#!/usr/bin/perl -w

# Sync webservers with snapshots - internetlynx.com.au
# Copyright 2006 clonepanel.com / internetlynx.com.au
# Version 0.30
# moveallmail.pl - copies mailboxes from mail directory to a clone

use lib "perl_modules";
use Mail::Box::Manager;
use File::Find;
use File::stat;

my ($fromdir,$todir) = @ARGV;
die "Usage: ./moveallmail.pl source_mail_dir dest_mail_dir"
	unless $fromdir && $todir;

my $mgr = new Mail::Box::Manager;

find({wanted=>\&movemailbox,no_chdir=>1}, $fromdir);


sub movemailbox {
	$st = stat($_);
	my $fromfile = $File::Find::name;
	(my $tofile = $fromfile) =~ s/$fromdir/$todir/;
	if ($st->mode & 0100000) {	#it's a file
		if ($st->size > 0) {	#and not empty
			my $mboxfrom = $mgr->open(folder => $fromfile, access => 'rw')
				or die "Unable to open source mailbox";
			my $mboxto = $mgr->open(folder => $tofile, access => 'rw', create => 1)
				or die "Unable to open destination mailbox";
		
			$mgr->moveMessage($mboxto, $mboxfrom->messages) or die "Move messages failed on $fromfile to $tofile";

			$mgr->close($mboxto);
			$mgr->close($mboxfrom);
warn "Moved messages from $fromfile to $tofile";
			chmod 0660, $tofile
				or die "Unable to change permissions on destination mailbox $tofile";
# Mail Box Manager leaves mailboxes with permissions 644 after transfer.
# This is possibly a bit insecure but the main reason for changing it is
# that some CPanel installations choke on Group not RW and refuse to deliver
# new messages (the mailbox is seen as RO perhaps?). It's not a true permissions
# problem because the mailbox can be chown user:user without issues - looks 
# like the Group permission is being used as a flag somehow...
		}
	} else {			#it's a directory
		if (opendir DIR, $tofile) {
			closedir DIR;
		} else {
			mkdir $tofile or die "Unable to create directory $tofile";
		}
	}
}
